--==========================================================================================================================
-- GEDEMON YNAEMP
--==========================================================================================================================
-- StartPosition 
------------------------------------------------------------	
CREATE TABLE IF NOT EXISTS StartPosition (MapName TEXT, Civilization TEXT, Leader TEXT, X INT default 0, Y INT default 0);
INSERT INTO StartPosition
		(Civilization,			Leader,					MapName, X,	Y)
SELECT	'CIVILIZATION_FRANCE',	'LEADER_JFD_DE_GAULLE',	MapName, X,	Y
FROM StartPosition WHERE Civilization = 'CIVILIZATION_FRANCE' AND Leader = 'LEADER_CATHERINE_DE_MEDICI';
--==========================================================================================================================
-- JFD RULE WITH FAITH
--==========================================================================================================================
-- Leader_Titles 
------------------------------------------------------------	
CREATE TABLE IF NOT EXISTS 
	Leader_Titles (
	LeaderType  					text 		 		default null,
	GovernmentType					text 	 			default null,
	LeaderTitle						text				default null,
	PolicyType  					text 		 		default null,
	UseFeminine						boolean				default 0,
	TitleIsFullName					boolean				default 0);	
	
INSERT INTO Leader_Titles
		(LeaderType, 				GovernmentType, 							PolicyType,				LeaderTitle)
VALUES	('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_JFD_DE_GAULLE'),				--Chiefdom
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_JFD_DE_GAULLE'),				--Autocracy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_JFD_DE_GAULLE'),				--Oligarchy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_JFD_DE_GAULLE'),	--Classical Democracy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_JFD_DE_GAULLE'),		--Merchant Republic
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_JFD_DE_GAULLE'),				--Feudal Monarchy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_JFD_DE_GAULLE'),				--Absolute Monarchy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_JFD_DE_GAULLE'),				--Constitutional Monarchy
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_JFD_DE_GAULLE'),		--Noble Republic
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_JFD_DE_GAULLE'),		--People's Republic
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_COMMUNISM',						null,					'LOC_GOVERNMENT_JFD_PEOPLES_REPUBLIC_LEADER_TITLE_JFD_DE_GAULLE'),		--People's Republic
		('LEADER_JFD_DE_GAULLE',	'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_JFD_DE_GAULLE'),	--Military Guardianship
		('LEADER_JFD_DE_GAULLE',	null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_JFD_DE_GAULLE');				--Empire

DELETE FROM Leader_Titles 
WHERE LeaderType = 'LEADER_JFD_DE_GAULLE' AND GovernmentType IS NOT null
AND GovernmentType NOT IN (SELECT GovernmentType FROM Governments);

DELETE FROM Leader_Titles 
WHERE LeaderType = 'LEADER_JFD_DE_GAULLE' AND PolicyType IS NOT null
AND PolicyType NOT IN (SELECT PolicyType FROM Policies);
--==========================================================================================================================
--==========================================================================================================================